/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.data.tempad_options;

import java.util.List;
import me.codexadrian.tempad.TempadType;
import me.codexadrian.tempad.data.tempad_options.TempadOption;
import me.codexadrian.tempad.items.EnergyItem;
import me.codexadrian.tempad.utils.ConfigUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnergyOption
extends TempadOption {
    public static final EnergyOption NORMAL_INSTANCE = new EnergyOption(TempadType.NORMAL);
    public static final EnergyOption ADVANCED_INSTANCE = new EnergyOption(TempadType.HE_WHO_REMAINS);

    public EnergyOption(TempadType type) {
        super(type);
    }

    @Override
    public boolean canTimedoorOpen(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof EnergyItem) {
            EnergyItem energyItem = (EnergyItem)item;
            return energyItem.hasEnoughEnergy(stack, ConfigUtils.getOptionConfig(this.getType()).getEnergyCost());
        }
        return false;
    }

    @Override
    public void onTimedoorOpen(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof EnergyItem) {
            EnergyItem energyItem = (EnergyItem)item;
            energyItem.drainEnergy(stack, ConfigUtils.getOptionConfig(this.getType()).getEnergyCost());
        }
    }

    @Override
    public void addToolTip(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        Item item = stack.m_41720_();
        if (item instanceof EnergyItem) {
            EnergyItem energyItem = (EnergyItem)item;
            components.add((Component)new TranslatableComponent("tooltip.tempad.energy_info", new Object[]{energyItem.getEnergy(stack), energyItem.getMaxEnergy()}).m_130940_(ChatFormatting.GRAY));
        }
        components.add((Component)new TranslatableComponent("tooltip.tempad.energy_cost", new Object[]{ConfigUtils.getOptionConfig(this.getType()).getEnergyCost()}).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Override
    public boolean isDurabilityBarVisible(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof EnergyItem) {
            EnergyItem energyItem = (EnergyItem)item;
            return energyItem.hasEnoughEnergy(stack, 1);
        }
        return false;
    }

    @Override
    public int durabilityBarWidth(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof EnergyItem) {
            EnergyItem energyItem = (EnergyItem)item;
            return (int)((double)energyItem.getEnergy(stack) / (double)energyItem.getMaxEnergy() * 13.0);
        }
        return 0;
    }

    public int getMaxEnergy() {
        return ConfigUtils.getOptionConfig(this.getType()).getEnergyCapacity();
    }
}

